// Copyright (C) 2012-2025 Zammad Foundation, https://zammad-foundation.org/

import { mountEditor } from './utils.ts'

describe('FieldEditor basic functionality', { retries: 2 }, () => {
  it('typing works, text becomes bold, when "B" is clicked', () => {
    mountEditor()

    cy.findByTestId('action-bar').should('not.be.visible')

    cy.findByRole('textbox').click()
    cy.findByTestId('action-bar').should('be.visible')

    cy.findByRole('textbox').type('Hello, World!{selectall}')

    cy.findByLabelText('Format as bold').click().should('have.class', 'bg-gray-300')

    cy.findByTestId('action-bar').should('be.visible') // should not disappear on click

    cy.findByRole('textbox').within((editor) => {
      expect(editor.find('strong')).to.have.text('Hello, World!')
    })
  })

  it('text is italic (or any other style) from the start', () => {
    mountEditor()

    cy.findByRole('textbox').click()
    cy.findByTestId('action-bar').findByLabelText('Format as italic').click()
    cy.findByRole('textbox').type('Hello, World!')

    cy.findByRole('textbox')
      .within((editor) => {
        expect(editor.find('em')).to.have.text('Hello, World!')
      })
      .selectText('left', 2)
      .findByLabelText('Format as italic')
      .click()

    cy.findByRole('textbox').within((editor) => {
      expect(editor.find('em')).to.have.text('Hello, Worl')
    })
  })

  it('has content when it is provided', () => {
    mountEditor({
      value: '<strong>Hello, World!</strong>',
    })

    cy.findByRole('textbox').should('have.text', 'Hello, World!')
    cy.findByRole('textbox').shouldHaveNormalizedHtml('<p><strong>Hello, World!</strong></p>')
  })

  // TODO: Clarify the paste handling in the editor.
  it.skip('pasting images inlines them', () => {
    mountEditor()

    cy.findByRole('textbox')
      .type('He')
      .selectText('left', 2)
      .then(() => {
        cy.findByTestId('action-bar').findByLabelText('Format as italic').click()
      })

    cy.findByRole('textbox')
      .type('{rightarrow}') // removing selection from realPress
      .paste({
        files: [new File(['0', '1'], 'name.jpeg', { type: 'image/jpeg' })],
      })
      .find('img')
      .should('have.attr', 'src', 'data:image/jpeg;base64,MDE=')
  })
})
